%------------------------------------------------------------------------------
% File     : QUA017^1 : TPTP v7.4.0. Released v4.1.0.
% Domain   : Quantales
% Problem  : Tests are idempotent with respect to multiplication
% Version  : [Hoe09] axioms.
% English  :

% Refs     : [Con71] Conway (1971), Regular Algebra and Finite Machines
%          : [Koz97] Kozen (1997), Kleene Algebra with Tests
%          : [Hoe09] Hoefner (2009), Email to Geoff Sutcliffe
% Source   : [Hoe09]
% Names    : QUA17 [Hoe09] 

% Status   : Theorem
% Rating   : 1.00 v4.1.0
% Syntax   : Number of formulae    :   29 (   0 unit;  13 type;   7 defn)
%            Number of atoms       :  115 (  21 equality;  51 variable)
%            Maximal formula depth :   12 (   5 average)
%            Number of connectives :   57 (   0   ~;   1   |;   6   &;  47   @)
%                                         (   1 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   44 (  44   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   16 (  13   :;   0   =)
%            Number of variables   :   30 (   1 sgn;  10   !;   5   ?;  15   ^)
%                                         (  30   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
%----Include axioms for Quantales
include('Axioms/QUA001^0.ax').
%----Include axioms for Tests for Quantales (Boolean sub-algebra below 1)
include('Axioms/QUA001^1.ax').
%------------------------------------------------------------------------------
thf(test_idemp,conjecture,(
    ! [X: $i] :
      ( ( test @ X )
     => ( ( multiplication @ X @ X )
        = X ) ) )).

%------------------------------------------------------------------------------
